#Conjoint Analysis Example
#Methods Workshop March 31, 2016

#We'll be using the cjoint package in R, which speaks nicely with the conjoint survey design tool Clara just showed us and allows us to easily estimate quantities of interest, like the AMCE. This brief tutorial is only scratching the surface of what can be done with this package and conjoint analysis more generally. 
#We'll be using Hainmueller et al.'s replication data from their immigration conjoint experiment where respondents were presented with different profiles of immigrants and asked to choose which to admit to the U.S. (this has been our main running example throughout the workshop).

#Set working directory
setwd("/Users/Taylor/Desktop/Conjoint Examples/")
	#Here you need to have (at least) two things stored: 
		#1. Your survey output file (i.e. csv of your data). This should be in the format where each row is a respondent-profile and each column is an attribute, your DVs, covariates about the respondent, and a respondent identifier. For example, if each respondent evaluated 5 choice tasks (choosing between 2 immigrant profiles 5 times), there would be 10 rows for each respondent. The DV in a choice conjoint is not stored as *which* immigrant they chose (where 1 is immigrant 1 and 0 is immigrant 2, for instance), rather it is whether they chose a given immigrant (i.e. for immigrant 1, 1=chose, 0=did not choose; for immigrant 2, 1=chose, 0=did not choose)
		#2. Your "design" file, which details the information about how many attributes you have, how many levels for each of those attributes, and how they were randomized. You can get this by using the "Export design to R" option in the survey design tool. If you didn't use the survey design tool, you can enter this information manually within the package instead, in which case you do not need this design file saved in your working directory. 
	
#Load cjoint package
library(cjoint)

#Load survey data from working directory 
immigrationconjoint<-read.csv("immigrationconjoint.csv")

#Note that these files are also stored within the package if you're having trouble getting the data going for any reason
#data("immigrationconjoint")
#data("immigrationdesign")

#Create a Design Object
#Because AMCEs are defined relative to the distribution of potential choice profiles, we need to know the options. There are several ways you can do this (see http://www.rdocumentation.org/packages/cjoint/functions/makeDesign.html) and we will use the "file" method, which uses the design from the Conjoint Survey Design Tool when using the "Export design to R" option.

immigrationdesign <- makeDesign(type="file", filename="immigrant.dat")

#Now calcualte the AMCEs
	#Here we use the amce() function to calculate teh AMCE
	#We enter in a formula, just as if we're running a regression where our DV goes first, followed by the attributes we're interested in, we specify our data and design objects, cluster, and specify how the respondents are identified. 
results<-amce(Chosen_Immigrant ~ Gender + Education + Job, data=immigrationconjoint, cluster=TRUE, respondent.id="CaseID", design=immigrationdesign)
summary(results)



